/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/

package cnrg.itx.signal.SignalEvent;

import cnrg.itx.ds.*;
import cnrg.itx.signal.*;

/** This class represents an event generated during the Dial Sequence in the non-blocking dial().
 */
public class DialSignalEvent extends SignalEvent
{
	/**  Location object of peer application **/
	public Location myCurrentPeer = null;
	
	/** Default Constructor
	 * 
	 * @param ip is the InvitePacket received
	 * @param sc is the SignalConnection in use
	 * @param cp is the location object of the current peer application
	 */
	public DialSignalEvent(InvitePacket ip, SignalConnection sc, Location cp){
		super(ip,sc);
		myCurrentPeer = cp;
	}
	
	/** Sets the location of the peer application
	 * 	 
	 * @param cp is the location object of the current peer application
	 * @return void.
	 */
	public void setCurrentPeer(Location cp){
		myCurrentPeer = cp;
	}
	
	/**  
	 * @return the location object for the current peer.
	 */
	public Location getCurrentPeer(){
		return myCurrentPeer;
	}
	
	/**  
	 * @return the reason the peer application rejected the call.
	 */
	public String getReason(){
		return myInviteInfo.getReason();
	}
}
